

module My_RPG


  class My_EventCommand < RPG::EventCommand

    include DMK_Constants

    attr_accessor :lieu
    attr_accessor :indent2

    
    def initialize(code = 0, indent = 0, parameters = [])
      @code = code
      #@indent = indent
      @parameters = parameters
      
    end

    def index
      return @lieu.list.index(self)
    end

    def page
      return @lieu
    end

    def page=(page)
      @lieu = page
    end


    def map
      return self.event.map
    end


    def event
      return self.page.event
    end


    def indent
      #return @indent2 if @indent2 != nil
      #if @lieu != nil
      return @lieu.indents[self]
      #else
      #  return 0
      #end
    end


    def self.from_rmxp(com)
      my = self.new(com.code, com.indent, com.parameters)

      return my

    end


    
    def to_rm03

      #p code
      contenu = to_128(@code)+to_128_inf(self.indent)

      # On regarde si le code fait partie de la liste des lments en ansi
      if $code_ansi.include?(@code)
        contenu << sized_string_ansi(@parameters[0]) << sized_string(@parameters[1])
      else
        contenu << sized_string(@parameters[0]) << sized_string(@parameters[1])
      end

      return contenu

    end




    def clone
      com = My_EventCommand.new(@code, self.indent, @parameters.clone)
      return com
    end








    ##########################################
    # Fonctions utilises
    ##########################################



    # Transforme la commande DMK au format RMXP
    # GOOD
    def to_rmxp
      return RPG::EventCommand.new(@code, self.indent, @parameters)
    end

    # Compare deux commandes entre elles
    # GOOD
    def comparer(command)
      
      raise(DMKW_DMK_Diff.new("EventCommand.code")) if @code != command.code
      raise(DMKW_DMK_Diff.new("EventCommand.indent")) if self.indent != command.indent
      raise(DMKW_DMK_Diff.new("EventCommand.parameters")) if @parameters != command.parameters
      return true
    end




    def semblable?(command)
      return false if command.is_a?(self.class) == false
      return false if @parameters != command.parameters
      return true
    end




  end




end